/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.accessibility.awb.canvas;

import com.sun.star.accessibility.XAccessibleEventBroadcaster;
import com.sun.star.accessibility.XAccessibleEventListener;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreeNode;
import org.openoffice.accessibility.awb.canvas.Canvas;
import org.openoffice.accessibility.awb.canvas.CanvasShape;

public class ShapeContainer
implements TreeModelListener,
TreeExpansionListener,
TreeWillExpandListener {
    private Hashtable maShapeList = new Hashtable();
    private Rectangle maBoundingBox = new Rectangle(0, 0, 100, 100);
    private Canvas maCanvas;
    private JTree maTree;

    public ShapeContainer(Canvas canvas) {
        this.maCanvas = canvas;
        this.maTree = null;
    }

    public synchronized void SetTree(JTree jTree) {
        if (jTree != this.maTree) {
            if (this.maTree != null) {
                this.maTree.getModel().removeTreeModelListener(this);
                this.maTree.removeTreeExpansionListener(this);
                this.maTree.removeTreeWillExpandListener(this);
            }
            this.Clear();
            this.maTree = jTree;
            this.maTree.getModel().addTreeModelListener(this);
            this.maTree.addTreeExpansionListener(this);
            this.maTree.addTreeWillExpandListener(this);
        }
    }

    public synchronized boolean AddNode(TreeNode treeNode) {
        CanvasShape canvasShape = (CanvasShape)this.maShapeList.get(treeNode);
        if (canvasShape == null) {
            canvasShape = new CanvasShape(treeNode, this.maCanvas);
            if (treeNode instanceof XAccessibleEventBroadcaster) {
                ((XAccessibleEventBroadcaster)treeNode).addEventListener((XAccessibleEventListener)canvasShape);
            }
            this.maBoundingBox = this.maShapeList.size() == 0 ? canvasShape.GetBBox() : this.maBoundingBox.union(canvasShape.GetBBox());
            this.maShapeList.put(treeNode, canvasShape);
            this.maCanvas.repaint();
            return true;
        }
        return false;
    }

    public synchronized boolean RemoveNode(TreeNode treeNode) {
        CanvasShape canvasShape = (CanvasShape)this.maShapeList.get(treeNode);
        if (canvasShape != null) {
            if (treeNode instanceof XAccessibleEventBroadcaster) {
                ((XAccessibleEventBroadcaster)treeNode).removeEventListener((XAccessibleEventListener)canvasShape);
            }
            this.maShapeList.remove(treeNode);
            this.maCanvas.SelectObject(null);
            this.maCanvas.repaint();
            return true;
        }
        return false;
    }

    public synchronized void Clear() {
        this.maShapeList.clear();
    }

    public Iterator GetIterator() {
        return this.maShapeList.values().iterator();
    }

    public CanvasShape Get(TreeNode treeNode) {
        if (treeNode != null) {
            return (CanvasShape)this.maShapeList.get(treeNode);
        }
        return null;
    }

    private void PrintMessage(String string, EventObject eventObject) {
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.PrintMessage("treeNodesChanged", treeModelEvent);
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.PrintMessage("treeNodesInserted", treeModelEvent);
        Object[] objectArray = treeModelEvent.getChildren();
        for (int i = 0; i < objectArray.length; ++i) {
            this.AddNode((TreeNode)objectArray[i]);
        }
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.PrintMessage("treeNodesRemoved", treeModelEvent);
        Object[] objectArray = treeModelEvent.getChildren();
        for (int i = 0; i < objectArray.length; ++i) {
            this.RemoveNode((TreeNode)objectArray[i]);
        }
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.PrintMessage("treeStructureChanged", treeModelEvent);
        TreeNode treeNode = (TreeNode)treeModelEvent.getTreePath().getLastPathComponent();
        this.RemoveAllChildren(treeNode);
        this.AddAllChildren(treeNode);
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
        this.PrintMessage("treeWillExpand", treeExpansionEvent);
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
        this.PrintMessage("treeWillCollapse", treeExpansionEvent);
        TreeNode treeNode = (TreeNode)treeExpansionEvent.getPath().getLastPathComponent();
        this.RemoveAllChildren(treeNode);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.PrintMessage("treeExpanded", treeExpansionEvent);
        TreeNode treeNode = (TreeNode)treeExpansionEvent.getPath().getLastPathComponent();
        this.AddAllChildren(treeNode);
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.PrintMessage("treeCollapsed", treeExpansionEvent);
    }

    private void AddAllChildren(TreeNode treeNode) {
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode2 = enumeration.nextElement();
            if (treeNode2 == null) continue;
            this.AddAllChildren(treeNode2);
            this.AddNode(treeNode2);
        }
    }

    private void RemoveAllChildren(TreeNode treeNode) {
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode2 = enumeration.nextElement();
            if (treeNode2 == null) continue;
            this.RemoveAllChildren(treeNode2);
            this.RemoveNode(treeNode2);
        }
    }
}

